/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.Objects;
import java.util.function.Supplier;

public class LazyOptional<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    private T value;

    private LazyOptional(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
            this.supplier = null;
            Objects.requireNonNull(this.value);
        }
        return this.value;
    }

    public T orElse(T object) {
        return this.get();
    }

    public static <T> LazyOptional<T> of(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new LazyOptional<T>(supplier);
    }
}

